#!/bin/sh

DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
DPLY_PAGE_MS_NETWORK_CONF_RESULT_OK=0
DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR=1

DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=${DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR}
DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0

DPLY_PAGE_MS_NETWORK_USER_INPUT_IP=""
DPLY_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
DPLY_PAGE_MS_NETWORK_USER_INPUT_DNS=""
DPLY_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""

dply_page_ms_network_conf() {
    debug_print "${0}" "${LINENO}" 'in function "dply_page_ms_network_conf"'

    # assign default value
    [ -z "${RT_MS_IP}" ]      && RT_MS_IP="${conf_ms_ip}"
    [ -z "${RT_MS_NETMASK}" ] && RT_MS_NETMASK="${conf_ms_netmask}"
    [ -z "${RT_MS_DNS}" ]     && RT_MS_DNS="${conf_ms_dns}"
    [ -z "${RT_MS_GATEWAY}" ] && RT_MS_GATEWAY="${conf_ms_gateway}"
    
    
	tp_network_conf \
		"${DPLY_PAGE_MS_NETWORK_CONF_TITLE}" \
		"${DPLY_PAGE_MS_NETWORK_CONF_TEXT}" \
		"${DPLY_PAGE_MS_NETWORK_CONF_LABEL_OK}" \
		"${DPLY_PAGE_MS_NETWORK_CONF_LABEL_CANCEL}" \
        "${DPLY_PAGE_MS_NETWORK_USER_INPUT_IP:-$RT_MS_IP}" \
        "${DPLY_PAGE_MS_NETWORK_USER_INPUT_NETMASK:-$RT_MS_NETMASK}" \
        "${DPLY_PAGE_MS_NETWORK_USER_INPUT_GATEWAY:-$RT_MS_GATEWAY}" \
        "${DPLY_PAGE_MS_NETWORK_USER_INPUT_DNS:-$RT_MS_DNS}"
        
        
    debug_print "${0}" "${LINENO}" "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"
            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_OK
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=-1
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
            
            DPLY_PAGE_MS_NETWORK_USER_INPUT_IP=""
            DPLY_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
            DPLY_PAGE_MS_NETWORK_USER_INPUT_DNS=""
            DPLY_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""
    			
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            ;;
        
        *)
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
            DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_MS_NETWORK_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    
    # apply and error handling
    utility_apply_ms_network_conf \
        "${RT_MS_DHCP}" \
        "${TP_NETWORK_CONF_RESULT_IP}" \
        "${TP_NETWORK_CONF_RESULT_NETMASK}" \
        "${TP_NETWORK_CONF_RESULT_GATEWAY}" \
        "${TP_NETWORK_CONF_RESULT_DNS}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_MS_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF}: ${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_MSG}"
		
         # revert to original setting
        local dhcp=`dtascfg "${DTASCFG_XML_FILE}" get management_server dhcp`
        utility_apply_ms_network_conf \
            "${dhcp}" \
            "${RT_MS_IP}" \
            "${RT_MS_NETMASK}" \
            "${RT_MS_GATEWAY}" \
            "${RT_MS_DNS}"
            
        DPLY_PAGE_MS_NETWORK_USER_INPUT_IP=${TP_NETWORK_CONF_RESULT_IP}
        DPLY_PAGE_MS_NETWORK_USER_INPUT_NETMASK=${TP_NETWORK_CONF_RESULT_NETMASK}
        DPLY_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=${TP_NETWORK_CONF_RESULT_GATEWAY}
        DPLY_PAGE_MS_NETWORK_USER_INPUT_DNS=${TP_NETWORK_CONF_RESULT_DNS}
   		
        return
    else
        DPLY_PAGE_MS_NETWORK_USER_INPUT_IP=""
        DPLY_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
        DPLY_PAGE_MS_NETWORK_USER_INPUT_DNS=""
        DPLY_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""		
    fi
    

    # save to database
    RT_MS_IP="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_IP}"
    RT_MS_NETMASK="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_NETMASK}"
    RT_MS_GATEWAY="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_GATEWAY}"
    RT_MS_DNS="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_DNS}"
    utility_save_ms_network_conf \
        "${RT_MS_DHCP}" \
        "${RT_MS_IP}" \
        "${RT_MS_NETMASK}" \
        "${RT_MS_GATEWAY}" \
        "${RT_MS_DNS}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_ERROR
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
        DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG="${DPLY_PAGE_MS_NETWORK_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_MS_NETWORK_CONF_RESULT_MSG}"
        return
    fi
        
    DPLY_PAGE_MS_NETWORK_CONF_RESULT_CODE=$DPLY_PAGE_MS_NETWORK_CONF_RESULT_OK
    DPLY_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=1
    DPLY_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
}